/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class UserContext
implements Serializable {
    public static final String TRACE_MASK = "HUSRCON";
    public static final String TRACE_MASKT = "HUSRCONT";
    public static final String TRACE_MASKF = "HUSRCONF";
    public static final String TRACE_MASKD = "HUSRCOND";
    public static final String THIS_CLASS = "UserContext";
    public static final int TYPE_HMC = 0;
    public static final int TYPE_USER = 1;
    public static final int TYPE_API = 2;
    public static final int TYPE_SYSTEM = 3;
    private static InheritableThreadLocal USER_CONTEXT = new InheritableThreadLocal();
    private String _creator = Thread.currentThread().getName();
    private String _userid;
    private String _clientKey;
    private InetAddress _address;
    private int _type;
    private UUID _id;
    private Locale _locale;
    private Locale[] _locales;
    private TimeZone timeZone;
    private Date _creationDate;
    private ContextId _contextId;

    public static UserContext getCurrentUserContext() {
        return (UserContext)USER_CONTEXT.get();
    }

    public UserContext(String userid, InetAddress address, int type, UUID id) {
        this(userid, address, type, id, null);
    }

    public UserContext(String userid, InetAddress address, int type, UUID id, Locale locale) {
        this._userid = userid;
        this._address = address;
        this._type = type;
        this._clientKey = null;
        this._id = id;
        this._locale = locale;
        this._creationDate = new Date();
        Trace.trace(TRACE_MASKD, "UserContext.UserContext:  created:  " + this);
        if (CommonSystem.getCommonSystem().isLocationClient()) {
            // empty if block
        }
    }

    public void setContextId(ContextId contextId) {
        this._contextId = contextId;
    }

    public ContextId getContextId() {
        return this._contextId;
    }

    public void setLocales(Locale[] locales) {
        this._locales = locales;
        if (locales.length > 0) {
            this._locale = locales[0];
        }
    }

    public Locale[] getLocales() {
        return this._locales;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return TimeZone.getDefault();
    }

    public void attachToThread() {
        USER_CONTEXT.set(this);
    }

    public String getUserid() {
        return this._userid;
    }

    public String getClientKey() {
        return this._clientKey;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public boolean isLocalContext() {
        Trace.trace(TRACE_MASKF, "--> UserContext.isLocalContext");
        if (this._address == null) {
            Trace.trace(TRACE_MASKF, "<-- UserContext.isLocalContext returning false, address is null");
            return false;
        }
        if (this._address.isLoopbackAddress()) {
            return true;
        }
        try {
            boolean result = NetworkInterface.getByInetAddress(this._address) != null;
            Trace.trace(TRACE_MASKF, "<-- UserContext.isLocalContext returning " + result + ", because of NetworkInterface.getByInetAddress result");
            return result;
        }
        catch (SocketException e) {
            Trace.trace(TRACE_MASKF, "<-- UserContext.isLocalContext returning false, because of socket exception");
            return false;
        }
    }

    public int getType() {
        return this._type;
    }

    public UUID getID() {
        return this._id;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public boolean isUser() {
        return this.getType() == 1;
    }

    public boolean isHMC() {
        return this.getType() == 0;
    }

    public boolean isSystem() {
        return this.getType() == 3;
    }

    public boolean isAuthenticated() {
        boolean isAuth = true;
        if (this.getType() == 3 || this.getType() == 0) {
            isAuth = false;
        } else if (this.getUserid() != null && this.getUserid().equalsIgnoreCase("logonuser")) {
            isAuth = false;
        }
        return isAuth;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof UserContext && ((UserContext)other).getID().equals(this.getID()) && ((UserContext)other).getUserid().equals(this.getUserid()) && ((UserContext)other).isUser() == this.isUser();
    }

    public String toString() {
        return "UserContext( user=" + this.getUserid() + ", locale=" + this.getLocale() + ", address=" + this.getAddress() + ", user connection=" + this.isUser() + ", id=" + this.getID() + ", creation date=" + this.getCreationDate() + ", created by=" + this._creator + ")";
    }
}

